/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericImageEncoder;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.io.JmolBinary;
import org.jmol.java.BS;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

abstract class OutputManager {
    protected Viewer vwr;
    protected double privateKey;
    protected static final String SCENE_TAG = "###scene.spt###";

    OutputManager() {
    }

    protected abstract String getLogPath(String var1);

    abstract String clipImageOrPasteText(String var1);

    abstract String getClipboardText();

    abstract OC openOutputChannel(double var1, String var3, boolean var4, boolean var5) throws IOException;

    protected abstract String createSceneSet(String var1, String var2, int var3, int var4);

    OutputManager setViewer(Viewer viewer, double d) {
        this.vwr = viewer;
        this.privateKey = d;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeToOutputChannel(Map<String, Object> map) {
        String string = (String)map.get("type");
        String string2 = (String)map.get("fileName");
        String string3 = (String)map.get("text");
        byte[] byArray = (byte[])map.get("bytes");
        int n = OutputManager.getInt(map, "quality", Integer.MIN_VALUE);
        OC oC = (OC)map.get("outputChannel");
        boolean bl = oC == null;
        int n2 = -1;
        String string4 = null;
        try {
            if (!this.vwr.checkPrivateKey(this.privateKey)) {
                String string5 = "ERROR: SECURITY";
                return string5;
            }
            if (byArray != null) {
                if (oC == null) {
                    oC = this.openOutputChannel(this.privateKey, string2, false, false);
                }
                oC.write(byArray, 0, byArray.length);
            } else if (string3 != null && !string.equals("ZIPDATA") && !string.equals("BINARY")) {
                if (oC == null) {
                    oC = this.openOutputChannel(this.privateKey, string2, true, false);
                }
                oC.append(string3);
            } else {
                String string6 = (String)this.getOrSaveImage(map);
                if (string6 != null) {
                    String string7 = string6;
                    return string7;
                }
                n2 = (Integer)map.get("byteCount");
            }
        }
        catch (Exception exception) {
            Logger.errorEx("IO Exception", exception);
            String string8 = exception.toString();
            return string8;
        }
        finally {
            if (oC != null) {
                if (bl) {
                    string4 = oC.closeChannel();
                }
                n2 = oC.getByteCount();
            }
        }
        int n3 = string2.indexOf("?POST?");
        if (n3 >= 0) {
            string2 = string2.substring(0, n3);
        }
        return n2 < 0 ? "Creation of " + string2 + " failed: " + (string4 == null ? this.vwr.getErrorMessageUn() : string4) : "OK " + string + " " + (n2 > 0 ? n2 + " " : "") + string2 + (n == Integer.MIN_VALUE ? "" : "; quality=" + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOrSaveImage(Map<String, Object> map) throws Exception {
        Object object;
        String string;
        String string2;
        byte[] byArray;
        block44: {
            boolean bl;
            String string3;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            OC oC;
            int[] nArray;
            String[] stringArray;
            String string4;
            block42: {
                String string5;
                block43: {
                    block40: {
                        String string6;
                        block41: {
                            block38: {
                                String string7;
                                block39: {
                                    byArray = null;
                                    string2 = null;
                                    string4 = ((String)map.get("type")).toUpperCase();
                                    string = (String)map.get("fileName");
                                    stringArray = (String[])map.get("scripts");
                                    object = map.get("image");
                                    nArray = (int[])map.get("rgbbuf");
                                    oC = (OC)map.get("outputChannel");
                                    bl4 = oC == null && string == null;
                                    bl3 = oC == null && string != null;
                                    boolean bl5 = bl2 = object == null;
                                    string3 = string4.equals("BINARY") || string4.equals("ZIPDATA") ? "" : (nArray != null ? (Object)nArray : (object != null ? object : this.vwr.getScreenImageBuffer(null, true)));
                                    bl = false;
                                    try {
                                        if (string3 != null) break block38;
                                        string7 = string2 = this.vwr.getErrorMessage();
                                        if (bl2) {
                                            this.vwr.releaseScreenImage();
                                        }
                                        if (byArray == null && oC == null) break block39;
                                        map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
                                    }
                                    catch (Throwable throwable) {
                                        if (bl2) {
                                            this.vwr.releaseScreenImage();
                                        }
                                        if (byArray != null || oC != null) {
                                            map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
                                        }
                                        if (object != null) {
                                            return string;
                                        }
                                        throw throwable;
                                    }
                                }
                                if (object != null) {
                                    return string;
                                }
                                return string7;
                            }
                            if (string == null || !string.startsWith("\u0001")) break block40;
                            bl = true;
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            hashtable.put("_IMAGE_", string3);
                            this.vwr.fm.loadImage(hashtable, string, false);
                            string6 = string2 = "OK - viewing " + string.substring(1);
                            if (bl2) {
                                this.vwr.releaseScreenImage();
                            }
                            if (byArray == null && oC == null) break block41;
                            map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
                        }
                        if (object != null) {
                            return string;
                        }
                        return string6;
                    }
                    if (oC == null) {
                        oC = this.openOutputChannel(this.privateKey, string, false, false);
                    }
                    if (oC != null) break block42;
                    string2 = "ERROR: canceled";
                    string5 = "ERROR: canceled";
                    if (bl2) {
                        this.vwr.releaseScreenImage();
                    }
                    if (byArray == null && oC == null) break block43;
                    map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
                }
                if (object != null) {
                    return string;
                }
                return string5;
            }
            string = oC.getFileName();
            String string8 = null;
            byte[] byArray2 = null;
            map.put("date", this.vwr.apiPlatform.getDateFormat("8601"));
            if (string4.startsWith("JP")) {
                if ((string4 = PT.rep(string4, "E", "")).equals("JPG64")) {
                    map.put("outputChannelTemp", this.getOutputChannel(null, null));
                    string8 = "";
                } else {
                    string8 = !bl4 ? (String)this.getWrappedState(null, null, string3, null) : "";
                }
                map.put("jpgAppTag", " #Jmol...\u0000");
            } else if (string4.equals("PDF")) {
                string8 = "";
            } else if (string4.startsWith("PNG")) {
                string8 = "";
                boolean bl6 = string4.equals("PNGJ");
                if (bl6) {
                    OC oC2 = this.getOutputChannel(null, null);
                    this.getWrappedState(string, stringArray, string3, oC2);
                    byArray2 = oC2.toByteArray();
                } else if (nArray == null && !bl4 && !map.containsKey("captureMode")) {
                    byArray2 = ((String)this.getWrappedState(null, stringArray, string3, null)).getBytes();
                }
                if (byArray2 != null) {
                    map.put("pngAppData", byArray2);
                    map.put("pngAppPrefix", "Jmol Type");
                }
            }
            if (string4.equals("PNGT") || string4.equals("GIFT")) {
                map.put("transparentColor", this.vwr.getBackgroundArgb());
            }
            if (string4.length() == 4) {
                string4 = string4.substring(0, 3);
            }
            if (string8 != null) {
                map.put("comment", string8.length() == 0 ? Viewer.getJmolVersion() : string8);
            }
            String[] stringArray2 = new String[1];
            bl = this.createTheImage(string3, string4, oC, map, stringArray2);
            if (bl3) {
                oC.closeChannel();
            }
            if (bl) {
                if (map.containsKey("captureMsg") && !map.containsKey("captureSilent")) {
                    this.vwr.prompt((String)map.get("captureMsg"), "OK", null, true);
                }
                if (bl4) {
                    byArray = oC.toByteArray();
                } else if (map.containsKey("captureByteCount")) {
                    string2 = "OK: " + map.get("captureByteCount").toString() + " bytes";
                }
            } else {
                string2 = stringArray2[0];
            }
            if (bl2) {
                this.vwr.releaseScreenImage();
            }
            if (byArray == null && oC == null) break block44;
            map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
        }
        if (object != null) {
            return string;
        }
        return string2 == null ? byArray : (byte[])string2;
    }

    Object getWrappedState(String string, String[] stringArray, Object object, OC oC) {
        int n = this.vwr.apiPlatform.getImageWidth(object);
        int n2 = this.vwr.apiPlatform.getImageHeight(object);
        if (n > 0 && !this.vwr.g.imageState && oC == null || !this.vwr.g.preserveState) {
            return "";
        }
        String string2 = this.vwr.getStateInfo3(null, n, n2);
        if (oC != null) {
            return this.createZipSet(string2, stringArray, true, oC, string);
        }
        try {
            string2 = JC.embedScript(FileManager.setScriptFileReferences(string2, ".", null, null));
        }
        catch (Throwable throwable) {
            Logger.error("state could not be saved: " + throwable.toString());
            string2 = "Jmol " + Viewer.getJmolVersion();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTheImage(Object object, String string, OC oC, Map<String, Object> map, String[] stringArray) {
        Object object2;
        boolean bl = (string = string.substring(0, 1) + string.substring(1).toLowerCase()).equals("Zipdata");
        if (bl || string.equals("Binary")) {
            object2 = (Lst)map.get("imageData");
            if (((ArrayList)object2).size() >= 2 && ((ArrayList)object2).get(0).equals("_IMAGE_")) {
                if (bl) {
                    stringArray[0] = this.writeZipFile(oC, (Lst<Object>)object2, "OK JMOL", null);
                    return true;
                }
                object = null;
                ((ArrayList)object2).remove(0);
                ((ArrayList)object2).remove(0);
                map.put("pngImgData", ((ArrayList)object2).remove(0));
                OC oC2 = this.getOutputChannel(null, null);
                stringArray[0] = this.writeZipFile(oC2, (Lst<Object>)object2, "OK JMOL", null);
                map.put("type", "PNGJ");
                string = "Png";
                map.put("pngAppPrefix", "Jmol Type");
                map.put("pngAppData", oC2.toByteArray());
            } else {
                if (((ArrayList)object2).size() == 1) {
                    byte[] byArray = (byte[])((ArrayList)object2).remove(0);
                    oC.write(byArray, 0, byArray.length);
                    return true;
                }
                stringArray[0] = this.writeZipFile(oC, (Lst<Object>)object2, "OK JMOL", null);
                return true;
            }
        }
        if ((object2 = (GenericImageEncoder)Interface.getInterface("javajs.img." + string + "Encoder", this.vwr, "file")) == null) {
            stringArray[0] = "Image encoder type " + string + " not available";
            return false;
        }
        boolean bl2 = true;
        try {
            int n;
            if (string.equals("Gif") && this.vwr.getTestFlag(2)) {
                map.put("reducedColors", Boolean.TRUE);
            }
            int n2 = object == null ? -1 : (n = AU.isAI(object) ? ((Integer)map.get("width")).intValue() : this.vwr.apiPlatform.getImageWidth(object));
            int n3 = object == null ? -1 : (AU.isAI(object) ? ((Integer)map.get("height")).intValue() : this.vwr.apiPlatform.getImageHeight(object));
            map.put("imageWidth", n);
            map.put("imageHeight", n3);
            int[] nArray = this.encodeImage(n, n3, object);
            if (nArray != null) {
                map.put("imagePixels", nArray);
            }
            map.put("logging", Logger.debugging);
            bl2 = object2.createImage(string, oC, map);
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
            oC.cancel();
            bl2 = true;
        }
        finally {
            if (bl2) {
                oC.closeChannel();
            }
        }
        return stringArray[0] == null;
    }

    private int[] encodeImage(int n, int n2, Object object) throws Exception {
        int[] nArray;
        if (n < 0) {
            return null;
        }
        if (AU.isAI(object)) {
            nArray = (int[])object;
        } else {
            nArray = new int[n * n2];
            nArray = this.vwr.apiPlatform.grabPixels(object, n, n2, nArray, 0, n2);
        }
        return nArray;
    }

    String outputToFile(Map<String, Object> map) {
        return this.handleOutputToFile(map, true);
    }

    OC getOutputChannel(String string, String[] stringArray) {
        if (!this.vwr.haveAccess(Viewer.ACCESS.ALL)) {
            return null;
        }
        if (string != null && (string = this.getOutputFileNameFromDialog(string, Integer.MIN_VALUE, null)) == null) {
            return null;
        }
        if (stringArray != null) {
            stringArray[0] = string;
        }
        String string2 = OC.isLocal(string) ? string : null;
        try {
            return this.openOutputChannel(this.privateKey, string2, false, false);
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
            return null;
        }
    }

    String processWriteOrCapture(Map<String, Object> map) {
        String string = (String)map.get("fileName");
        if (string == null) {
            return this.vwr.clipImageOrPasteText((String)map.get("text"));
        }
        BS bS = (BS)map.get("bsFrames");
        int n = OutputManager.getInt(map, "nVibes", 0);
        return bS != null || n != 0 ? this.processMultiFrameOutput(string, bS, n, map) : this.handleOutputToFile(map, true);
    }

    private static int getInt(Map<String, Object> map, String string, int n) {
        Integer n2 = (Integer)map.get(string);
        return n2 == null ? n : n2;
    }

    private String processMultiFrameOutput(String string, BS bS, int n, Map<String, Object> map) {
        String string2 = "";
        int n2 = 0;
        int n3 = OutputManager.getInt(map, "quality", -1);
        if ((string = this.setFullPath(map, this.getOutputFileNameFromDialog(string, n3, null))) == null) {
            return null;
        }
        String[] stringArray = new String[2];
        OutputManager.getRootExt(string, stringArray, 0);
        SB sB = new SB();
        if (bS == null) {
            this.vwr.tm.vibrationOn = true;
            sB = new SB();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 20; ++j) {
                    this.vwr.tm.setVibrationT((float)j / 20.0f + 0.2501f);
                    if (this.writeFrame(++n2, stringArray, map, sB)) continue;
                    return "ERROR WRITING FILE SET: \n" + string2;
                }
            }
            this.vwr.tm.setVibrationPeriod(0.0f);
        } else {
            int n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                this.vwr.setCurrentModelIndex(n4);
                if (!this.writeFrame(++n2, stringArray, map, sB)) {
                    return "ERROR WRITING FILE SET: \n" + string2;
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        if (string2.length() == 0) {
            string2 = "OK\n";
        }
        return string2 + "\n" + n2 + " files created";
    }

    private static Object getRootExt(String string, String[] stringArray, int n) {
        String string2;
        if (string == null) {
            string = "0000" + n;
            return stringArray[0] + string.substring(string.length() - 4) + stringArray[1];
        }
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            n2 = string.length();
        }
        if ((string2 = string.substring(0, n2)).endsWith("0")) {
            string2 = PT.trim(string2, "0");
        }
        stringArray[0] = string2;
        stringArray[1] = string.substring(n2);
        return stringArray;
    }

    private String setFullPath(Map<String, Object> map, String string) {
        String[] stringArray = (String[])map.get("fullPath");
        if (stringArray != null) {
            stringArray[0] = string;
        }
        if (string == null) {
            return null;
        }
        map.put("fileName", string);
        return string;
    }

    String getOutputFromExport(Map<String, Object> map) {
        int n = OutputManager.getInt(map, "width", 0);
        int n2 = OutputManager.getInt(map, "height", 0);
        String string = (String)map.get("fileName");
        if (string != null && (string = this.setFullPath(map, this.getOutputFileNameFromDialog(string, Integer.MIN_VALUE, null))) == null) {
            return null;
        }
        this.vwr.mustRender = true;
        int n3 = this.vwr.dimScreen.width;
        int n4 = this.vwr.dimScreen.height;
        this.vwr.resizeImage(n, n2, true, true, false);
        this.vwr.setModelVisibility();
        String string2 = this.vwr.rm.renderExport(this.vwr.gdata, this.vwr.ms, map);
        this.vwr.resizeImage(n3, n4, true, true, true);
        return string2;
    }

    byte[] getImageAsBytes(String string, int n, int n2, int n3, String[] stringArray) {
        int n4 = this.vwr.dimScreen.width;
        int n5 = this.vwr.dimScreen.height;
        this.vwr.mustRender = true;
        this.vwr.resizeImage(n, n2, true, false, false);
        this.vwr.setModelVisibility();
        this.vwr.creatingImage = true;
        byte[] byArray = null;
        try {
            Object object;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("type", string);
            if (n3 > 0) {
                hashtable.put("quality", n3);
            }
            if ((object = this.getOrSaveImage(hashtable)) instanceof String) {
                stringArray[0] = (String)object;
            } else {
                byArray = (byte[])object;
            }
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
            this.vwr.setErrorMessage("Error creating image: " + exception, null);
        }
        catch (Error error) {
            this.vwr.handleError(error, false);
            this.vwr.setErrorMessage("Error creating image: " + error, null);
            stringArray[0] = this.vwr.getErrorMessage();
        }
        this.vwr.creatingImage = false;
        this.vwr.resizeImage(n4, n5, true, false, true);
        return byArray;
    }

    String writeFileData(String string, String string2, int n, Object[] objectArray) {
        boolean bl;
        String[] stringArray = new String[1];
        OC oC = this.getOutputChannel(string, stringArray);
        if (oC == null) {
            return "";
        }
        string = stringArray[0];
        String string3 = string2.equals("FILE") ? this.vwr.fm.getFullPathName(false) : null;
        boolean bl2 = string3 != null && (string3.equals("string") || string3.indexOf("[]") >= 0 || string3.equals("JSNode"));
        boolean bl3 = bl = string3 != null && !bl2;
        if (bl && (string3 = this.vwr.getModelSetPathName()) == null) {
            return null;
        }
        oC.setType(string2);
        String string4 = string2.startsWith("PDB") ? this.vwr.getPdbAtomData(null, oC, false, false) : (string2.startsWith("PLOT") ? this.vwr.getPdbData(n, string2.substring(5), null, objectArray, oC, true) : (bl2 ? oC.append(this.vwr.getCurrentFileAsString("write")).toString() : (String)this.vwr.fm.getFileAsBytes(string3, oC)));
        oC.closeChannel();
        if (string4 != null) {
            string4 = "OK " + string4 + " " + string;
        }
        return string4;
    }

    private boolean writeFrame(int n, String[] stringArray, Map<String, Object> map, SB sB) {
        String string = (String)OutputManager.getRootExt(null, stringArray, n);
        if ((string = this.setFullPath(map, string)) == null) {
            return false;
        }
        String string2 = this.handleOutputToFile(map, false);
        this.vwr.scriptEcho(string2);
        sB.append(string2).append("\n");
        return string2.startsWith("OK");
    }

    private String getOutputFileNameFromDialog(String string, int n, Map<String, Object> map) {
        if (string == null || this.vwr.isKiosk) {
            return null;
        }
        boolean bl = string.startsWith("?");
        if (bl) {
            string = string.substring(1);
        }
        boolean bl2 = this.vwr.isApplet && string.indexOf("http:") < 0;
        string = FileManager.getLocalPathForWritingFile(this.vwr, string);
        if (bl |= bl2) {
            string = this.vwr.dialogAsk(n == Integer.MIN_VALUE ? "Save" : "Save Image", string, map);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleOutputToFile(Map<String, Object> map, boolean bl) {
        String string = null;
        String string2 = (String)map.get("fileName");
        if (string2 == null) {
            return null;
        }
        String string3 = (String)map.get("type");
        String string4 = (String)map.get("text");
        int n = OutputManager.getInt(map, "width", 0);
        int n2 = OutputManager.getInt(map, "height", 0);
        int n3 = OutputManager.getInt(map, "quality", Integer.MIN_VALUE);
        String string5 = (String)map.get("captureMode");
        if (string5 != null && !this.vwr.allowCapture()) {
            return "ERROR: Cannot capture on this platform.";
        }
        boolean bl2 = n3 != Integer.MIN_VALUE;
        String string6 = null;
        if (string5 != null) {
            bl = false;
            bl2 = false;
        }
        if (!string2.startsWith("\u0001")) {
            if (bl) {
                string2 = this.getOutputFileNameFromDialog(string2, n3, map);
            }
            string2 = this.setFullPath(map, string2);
        }
        if (string2 == null) {
            return null;
        }
        map.put("fileName", string2);
        if (OC.isLocal(string2)) {
            string6 = string2;
        }
        int n4 = this.vwr.dimScreen.width;
        int n5 = this.vwr.dimScreen.height;
        this.vwr.creatingImage = true;
        if (bl2) {
            this.vwr.mustRender = true;
            this.vwr.resizeImage(n, n2, true, false, false);
            this.vwr.setModelVisibility();
        }
        try {
            if (string3.equals("JMOL")) {
                string3 = "ZIPALL";
            }
            if (string3.equals("ZIP") || string3.equals("ZIPALL")) {
                String[] stringArray = (String[])map.get("scripts");
                if (stringArray != null && string3.equals("ZIP")) {
                    string3 = "ZIPALL";
                }
                string = this.createZipSet(string4, stringArray, string3.equals("ZIPALL"), this.getOutputChannel(string2, null), null);
            } else if (string3.equals("SCENE")) {
                string = this.createSceneSet(string2, string4, n, n2);
            } else {
                byte[] byArray = (byte[])map.get("bytes");
                string = this.vwr.sm.createImage(string2, string3, string4, byArray, n3);
                if (string == null) {
                    boolean bl3 = true;
                    String string7 = null;
                    if (string5 != null) {
                        String[] stringArray;
                        int n6;
                        OC oC = null;
                        Map<String, Object> map2 = this.vwr.captureParams;
                        int n7 = "ad on of en ca mo ".indexOf(string5.substring(0, 2));
                        if (n7 == 15) {
                            if (map2 != null && map2.containsKey("outputChannel")) {
                                ((OC)map2.get("outputChannel")).closeChannel();
                            }
                            if ((n6 = map.containsKey("streaming")) != 0 && (oC = this.getOutputChannel(string6, null)) == null) {
                                string7 = "ERROR: capture canceled";
                                string = "ERROR: capture canceled";
                                this.vwr.captureParams = null;
                            } else {
                                this.vwr.captureParams = map;
                                if (map.containsKey("captureRootExt")) {
                                    n7 = 0;
                                } else {
                                    if (oC != null) {
                                        string6 = oC.getFileName();
                                    }
                                    map.put("captureFileName", string6);
                                    if (n6 != 0) {
                                        string7 = string3 + "_STREAM_OPEN " + string6;
                                        map.put("captureMode", "movie");
                                    } else {
                                        stringArray = new String[2];
                                        map.put("captureRootExt", OutputManager.getRootExt(string6, stringArray, 0));
                                        string6 = (String)OutputManager.getRootExt(null, stringArray, 1);
                                        n7 = -1;
                                        map2 = map;
                                        bl3 = false;
                                    }
                                }
                                if (!map.containsKey("captureCount")) {
                                    map.put("captureCount", 0);
                                }
                            }
                        }
                        if (n7 >= 0 && n7 != 15) {
                            if (map2 == null) {
                                string7 = "ERROR: capture not active";
                                string = "ERROR: capture not active";
                            } else {
                                map = map2;
                                switch (n7) {
                                    default: {
                                        string = string7 = "ERROR: CAPTURE MODE=" + string5 + "?";
                                        break;
                                    }
                                    case 0: {
                                        if (Boolean.FALSE == map.get("captureEnabled")) {
                                            string7 = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                            string = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                            break;
                                        }
                                        n6 = OutputManager.getInt(map, "captureCount", 0);
                                        map.put("captureCount", ++n6);
                                        stringArray = (String[])map.get("captureRootExt");
                                        if (stringArray != null) {
                                            string6 = (String)OutputManager.getRootExt(null, stringArray, n6);
                                            string7 = null;
                                            bl3 = true;
                                            break;
                                        }
                                        string7 = string3 + "_STREAM_ADD " + n6;
                                        break;
                                    }
                                    case 3: 
                                    case 6: {
                                        map = map2;
                                        map.put("captureEnabled", string5.equals("on") ? Boolean.TRUE : Boolean.FALSE);
                                        string = string3 + "_STREAM_" + (string5.equals("on") ? "ON" : "OFF");
                                        map.put("captureMode", "add");
                                        break;
                                    }
                                    case 9: 
                                    case 12: {
                                        map = map2;
                                        map.put("captureMode", string5);
                                        string2 = (String)map.get("captureFileName");
                                        string7 = string3 + "_STREAM_" + (string5.equals("end") ? "CLOSE " : "CANCEL ") + string2;
                                        this.vwr.captureParams = null;
                                        map.put("captureMsg", GT._("Capture") + ": " + (string5.equals("cancel") ? GT._("canceled") : GT.o(GT._("{0} saved"), string2)));
                                        if (!map.containsKey("captureRootExt")) break;
                                        bl3 = false;
                                    }
                                }
                            }
                        }
                        if (bl3 && oC != null) {
                            map.put("outputChannel", oC);
                        }
                    }
                    if (bl3) {
                        if (string6 != null) {
                            map.put("fileName", string6);
                        }
                        if (string == null) {
                            string = this.writeToOutputChannel(map);
                        }
                        this.vwr.sm.createImage(string, string3, null, null, n3);
                        if (string5 != null) {
                            string7 = string7 == null ? string : string7 + " (" + map.get(map.containsKey("captureByteCount") ? "captureByteCount" : "byteCount") + " bytes)";
                        }
                    }
                    if (string7 != null) {
                        this.vwr.showString(string7, false);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string = "ERROR creating image??: " + throwable;
            Logger.error(this.vwr.setErrorMessage(string, null));
        }
        finally {
            this.vwr.creatingImage = false;
            if (n3 != Integer.MIN_VALUE) {
                this.vwr.resizeImage(n4, n5, true, false, true);
            }
        }
        return string;
    }

    String setLogFile(String string) {
        String string2 = null;
        if (this.vwr.logFilePath == null || string.indexOf("\\") >= 0) {
            string = null;
        } else if (string.startsWith("http://") || string.startsWith("https://")) {
            string2 = string;
        } else if (string.indexOf("/") >= 0) {
            string = null;
        } else if (string.length() > 0) {
            if (!string.startsWith("JmolLog_")) {
                string = "JmolLog_" + string;
            }
            string2 = this.getLogPath(this.vwr.logFilePath + string);
        }
        if (string2 == null) {
            string = null;
        } else {
            Logger.info(GT.o(GT._("Setting log file to {0}"), string2));
        }
        if (string == null || !this.vwr.haveAccess(Viewer.ACCESS.ALL)) {
            Logger.info(GT._("Cannot set log file path."));
            string = null;
        } else {
            this.vwr.logFileName = string2;
            this.vwr.g.setO("_logFile", this.vwr.isApplet ? string : string2);
        }
        return string;
    }

    void logToFile(String string) {
        block7: {
            try {
                OC oC;
                boolean bl = string.equals("$CLEAR$");
                if (string.indexOf("$NOW$") >= 0) {
                    string = PT.rep(string, "$NOW$", this.vwr.apiPlatform.getDateFormat(null));
                }
                if (this.vwr.logFileName == null) {
                    Logger.info(string);
                    return;
                }
                OC oC2 = this.vwr.haveAccess(Viewer.ACCESS.ALL) ? this.openOutputChannel(this.privateKey, this.vwr.logFileName, true, !bl) : (oC = null);
                if (!bl) {
                    int n = string.indexOf(0);
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    oC.append(string);
                    if (n < 0) {
                        oC.append("\n");
                    }
                }
                String string2 = oC.closeChannel();
                Logger.info(string2);
            }
            catch (Exception exception) {
                if (!Logger.debugging) break block7;
                Logger.debug("cannot log " + string);
            }
        }
    }

    private String createZipSet(String string, String[] stringArray, boolean bl, OC oC, String string2) {
        byte[] byArray;
        String string3;
        int n;
        boolean bl2;
        boolean bl3;
        Lst<Object> lst = new Lst<Object>();
        FileManager fileManager = this.vwr.fm;
        Lst<String> lst2 = new Lst<String>();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        boolean bl4 = stringArray != null && stringArray.length == 3 && stringArray[1].startsWith(SCENE_TAG);
        boolean bl5 = bl3 = bl4 && stringArray[2].equals("min");
        if (!bl3) {
            JmolBinary.getFileReferences(string, lst2);
            if (bl4) {
                JmolBinary.getFileReferences(stringArray[1], lst2);
            }
        }
        boolean bl6 = bl2 = !bl4 && stringArray != null && stringArray.length > 0;
        if (bl2) {
            string = this.wrapPathForAllFiles("script " + PT.esc(stringArray[0]), "");
            for (n = 0; n < stringArray.length; ++n) {
                lst2.addLast(stringArray[n]);
            }
        }
        n = lst2.size();
        Lst<String> lst3 = new Lst<String>();
        for (int i = 0; i < n; ++i) {
            string3 = (String)lst2.get(i);
            boolean bl7 = !this.vwr.isJS && OC.isLocal(string3);
            String string4 = string3;
            if (bl7 || bl) {
                boolean bl8;
                int n2 = string3.lastIndexOf("/");
                string4 = string3.indexOf("?") > 0 && string3.indexOf("|") < 0 ? PT.replaceAllCharacters(string3, "/:?\"'=&", "_") : FileManager.stripPath(string3);
                string4 = PT.replaceAllCharacters(string4, "[]", "_");
                boolean bl9 = bl8 = fileManager.spardirCache != null && fileManager.spardirCache.containsKey(string3);
                if (bl7 && string3.indexOf("|") < 0 && !bl8) {
                    lst.addLast(string3);
                    lst.addLast(string4);
                    lst.addLast((Object)null);
                } else {
                    Object object;
                    Object object2 = object = bl8 ? fileManager.spardirCache.get(string3) : (Object)fileManager.getFileAsBytes(string3, null);
                    if (!AU.isAB(object)) {
                        return (String)object;
                    }
                    string4 = this.addPngFileBytes(string3, (byte[])object, i, hashtable, bl8, string4, n2, lst);
                }
                string3 = "$SCRIPT_PATH$" + string4;
            }
            hashtable.put(string4, string4);
            lst3.addLast(string3);
        }
        if (!bl3) {
            string = PT.replaceQuotedStrings(string, lst2, lst3);
            lst.addLast("state.spt");
            lst.addLast((Object)null);
            lst.addLast(string.getBytes());
        }
        if (bl4) {
            if (stringArray[0] != null) {
                lst.addLast("animate.spt");
                lst.addLast((Object)null);
                lst.addLast(stringArray[0].getBytes());
            }
            lst.addLast("scene.spt");
            lst.addLast((Object)null);
            string = PT.replaceQuotedStrings(stringArray[1], lst2, lst3);
            lst.addLast(string.getBytes());
        }
        String string5 = bl4 ? "scene.spt" : "state.spt";
        lst.addLast("JmolManifest.txt");
        lst.addLast((Object)null);
        string3 = "# Jmol Manifest Zip Format 1.1\n# Created " + new Date() + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string5;
        lst.addLast(string3.getBytes());
        lst.addLast("Jmol_version_" + Viewer.getJmolVersion().replace(' ', '_').replace(':', '.'));
        lst.addLast((Object)null);
        lst.addLast(new byte[0]);
        if (oC.getFileName() != null && (byArray = this.vwr.getImageAsBytes("PNG", 0, 0, -1, null)) != null) {
            lst.addLast("preview.png");
            lst.addLast((Object)null);
            lst.addLast(byArray);
        }
        return this.writeZipFile(oC, lst, "OK JMOL", string2);
    }

    private String addPngFileBytes(String string, byte[] byArray, int n, Hashtable<Object, String> hashtable, boolean bl, String string2, int n2, Lst<Object> lst) {
        Integer n3 = this.vwr.getJzt().getCrcValue(byArray);
        if (hashtable.containsKey(n3)) {
            string2 = hashtable.get(n3);
        } else {
            if (bl) {
                string2 = string2.replace('.', '_');
            }
            if (hashtable.containsKey(string2)) {
                int n4 = string2.lastIndexOf(".");
                string2 = n4 > n2 ? string2.substring(0, n4) + "[" + n + "]" + string2.substring(n4) : string2 + "[" + n + "]";
            }
            lst.addLast(string);
            lst.addLast(string2);
            lst.addLast(byArray);
            hashtable.put(n3, string2);
        }
        return string2;
    }

    private String writeZipFile(OC oC, Lst<Object> lst, String string, String string2) {
        Object object;
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        String string3 = oC.getFileName();
        if (string2 != null && string2.startsWith("//")) {
            string2 = "file:" + string2.substring(1);
        }
        Logger.info("creating zip file " + (string3 == null ? "" : string3) + "...");
        String string4 = "";
        try {
            object = new BufferedOutputStream(oC);
            FileManager fileManager = this.vwr.fm;
            OutputStream outputStream = (OutputStream)this.vwr.getJzt().getZipOutputStream(object);
            for (int i = 0; i < lst.size(); i += 3) {
                String string5;
                String string6;
                String string7 = (String)lst.get(i);
                byte[] byArray2 = null;
                Object object2 = fileManager.cacheGet(string7, false);
                if (object2 instanceof Map) continue;
                if (string7.indexOf("file:/") == 0) {
                    if ((string7 = string7.substring(5)).length() > 2 && string7.charAt(2) == ':') {
                        string7 = string7.substring(1);
                    }
                } else if (string7.indexOf("cache://") == 0) {
                    string7 = string7.substring(8);
                }
                if ((string6 = (String)lst.get(i + 1)) == null) {
                    string6 = string7;
                }
                if (object2 != null) {
                    byte[] byArray3 = byArray2 = AU.isAB(object2) ? (byte[])object2 : ((String)object2).getBytes();
                }
                if (byArray2 == null) {
                    byArray2 = (byte[])lst.get(i + 2);
                }
                if (string4.indexOf(string5 = ";" + string6 + ";") >= 0) {
                    Logger.info("duplicate entry");
                    continue;
                }
                string4 = string4 + string5;
                this.vwr.getJzt().addZipEntry(outputStream, string6);
                int n = 0;
                if (byArray2 == null) {
                    int n2;
                    BufferedInputStream bufferedInputStream = this.vwr.getBufferedInputStream(string7);
                    while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                        outputStream.write(byArray, 0, n2);
                        n += n2;
                    }
                    bufferedInputStream.close();
                } else {
                    outputStream.write(byArray2, 0, byArray2.length);
                    if (string2 != null) {
                        this.vwr.fm.recachePngjBytes(string2 + "|" + string6, byArray2);
                    }
                    n += byArray2.length;
                }
                l += (long)n;
                this.vwr.getJzt().closeZipEntry(outputStream);
                Logger.info("...added " + string7 + " (" + n + " bytes)");
            }
            outputStream.flush();
            outputStream.close();
            Logger.info(l + " bytes prior to compression");
            String string8 = oC.closeChannel();
            if (string8 != null) {
                if (string8.indexOf("Exception") >= 0) {
                    return string8;
                }
                string = string + " " + string8;
            }
            l2 = oC.getByteCount();
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
            return iOException.toString();
        }
        object = oC.getFileName();
        return object == null ? null : string + " " + l2 + " " + (String)object;
    }

    protected String wrapPathForAllFiles(String string, String string2) {
        String string3 = "v__" + ("" + Math.random()).substring(3);
        return "# Jmol script\n{\n\tVar " + string3 + " = pathForAllFiles\n\tpathForAllFiles=\"$SCRIPT_PATH$\"\n\ttry{\n\t\t" + string + "\n\t}catch(e){" + string2 + "}\n\tpathForAllFiles = " + string3 + "\n}\n";
    }
}

