/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.awt.Font;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.modelset.Object2d;
import org.jmol.shape.Shape;
import org.jmol.util.Txt;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Text
extends Object2d {
    private static boolean isEcho;
    public String textUnformatted;
    public boolean doFormatText;
    public String[] lines;
    public Font font;
    private byte fid;
    private int ascent;
    public int descent;
    private int lineHeight;
    protected int offsetX;
    protected int offsetY;
    private int textWidth;
    private int textHeight;
    private String text;
    private int[] widths;
    private Viewer vwr;
    public Object image;
    public float imageScale = 1.0f;
    public int boxYoff2;
    private float xAdj;
    private float yAdj;
    private float y0;
    public P3 pointerPt;

    public String getText() {
        return this.text;
    }

    public void setOffset(int n) {
        this.offsetX = JC.getXOffset(n);
        this.offsetY = JC.getYOffset(n);
        this.pymolOffset = null;
        this.valign = 3;
    }

    private Text(Viewer viewer) {
        this.vwr = viewer;
        this.boxXY = new float[5];
    }

    public static Text newLabel(Viewer viewer, Font font, String string, short s, short s2, int n, float f, float[] fArray) {
        Text text = new Text(viewer);
        text.set(font, s, n, true, f, fArray);
        text.setText(string);
        text.bgcolix = s2;
        return text;
    }

    public static Text newEcho(Viewer viewer, Font font, String string, short s, int n, int n2, float f) {
        isEcho = true;
        Text text = new Text(viewer);
        text.set(font, s, n2, false, f, null);
        text.target = string;
        if (string.equals("error")) {
            n = 0;
        }
        text.valign = n;
        text.z = 2;
        text.zSlab = Integer.MIN_VALUE;
        return text;
    }

    private void set(Font font, short s, int n, boolean bl, float f, float[] fArray) {
        this.scalePixelsPerMicron = f;
        this.isLabelOrHover = bl;
        this.colix = s;
        this.align = n;
        this.pymolOffset = fArray;
        this.setFont(font, bl);
    }

    private void getFontMetrics() {
        this.descent = this.font.getDescent();
        this.ascent = this.font.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    public void setFontFromFid(byte by) {
        if (this.fid == by) {
            return;
        }
        this.fontScale = 0.0f;
        this.setFont(Font.getFont3D(by), true);
    }

    public void setText(String string) {
        if (this.image != null) {
            this.getFontMetrics();
        }
        this.image = null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (this.text != null && this.text.equals(string)) {
            return;
        }
        this.text = string;
        this.textUnformatted = string;
        boolean bl = this.doFormatText = isEcho && string != null && (string.indexOf("%{") >= 0 || string.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    public void setImage(Object object) {
        this.image = object;
        this.recalc();
    }

    public void setScale(float f) {
        this.imageScale = f;
        this.recalc();
    }

    public void setFont(Font font, boolean bl) {
        this.font = font;
        if (this.font == null) {
            return;
        }
        this.getFontMetrics();
        if (!bl) {
            return;
        }
        this.fid = this.font.fid;
        this.recalc();
    }

    public void setFontScale(float f) {
        if (this.fontScale == f) {
            return;
        }
        this.fontScale = f;
        if (this.fontScale != 0.0f) {
            this.setFont(this.vwr.gdata.getFont3DScaled(this.font, f), true);
        }
    }

    @Override
    protected void recalc() {
        if (this.image != null) {
            this.textHeight = 0;
            this.textWidth = 0;
            this.boxWidth = (float)this.vwr.apiPlatform.getImageWidth(this.image) * this.fontScale * this.imageScale;
            this.boxHeight = (float)this.vwr.apiPlatform.getImageHeight(this.image) * this.fontScale * this.imageScale;
            this.ascent = 0;
            return;
        }
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.font == null) {
            return;
        }
        this.lines = PT.split(this.text, this.text.indexOf("\n") >= 0 ? "\n" : "|");
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int n = this.lines.length;
        while (--n >= 0) {
            this.widths[n] = this.stringWidth(this.lines[n]);
            this.textWidth = Math.max(this.textWidth, this.widths[n]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + (this.fontScale >= 2.0f ? 16 : 8);
        this.boxHeight = this.textHeight + (this.fontScale >= 2.0f ? 16 : 8);
    }

    public void formatText() {
        this.text = isEcho ? Txt.formatText(this.vwr, this.textUnformatted) : this.textUnformatted;
        this.recalc();
    }

    public void setPosition(float f, float f2, boolean bl, float[] fArray) {
        if (fArray == null) {
            fArray = this.boxXY;
        } else {
            this.boxXY = fArray;
        }
        this.setWindow(this.vwr.gdata.width, this.vwr.gdata.height, f);
        if (f != 0.0f && this.scalePixelsPerMicron != 0.0f) {
            this.setFontScale(f / this.scalePixelsPerMicron);
        } else if (this.fontScale != f2) {
            this.setFontScale(f2);
        }
        if (this.doFormatText) {
            this.formatText();
        }
        float f3 = (float)this.offsetX * f2;
        float f4 = (float)this.offsetY * f2;
        this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
        this.yAdj = (float)(this.ascent - this.lineHeight) + this.xAdj;
        if (this.isLabelOrHover) {
            fArray[0] = this.movableX;
            fArray[1] = this.movableY;
            if (this.pymolOffset != null) {
                float f5 = this.vwr.tm.scaleToScreen(this.z, 1000);
                float f6 = this.pymolOffset[3];
                float f7 = (float)(f6 < 0.0f ? -1 : 1) * Math.max(0.0f, Math.abs(f6) - 1.0f) * f5;
                this.z -= (int)f7;
                f5 = this.vwr.tm.scaleToScreen(this.z, 1000);
                f3 = this.getPymolXYOffset(this.pymolOffset[1], this.textWidth, f5);
                f4 = -this.getPymolXYOffset(-this.pymolOffset[2], this.ascent - this.descent, f5);
                this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
                this.yAdj = 0.0f;
                fArray[0] = (float)this.movableX - this.xAdj;
                fArray[1] = (float)this.movableY - this.yAdj;
                this.y0 = (float)this.movableY - (f4 += (float)this.descent) - (float)this.descent;
                bl = true;
                this.boxYoff2 = -2;
            } else {
                this.boxYoff2 = 0;
            }
            Text.setBoxXY(this.boxWidth, this.boxHeight, f3, f4, fArray, bl);
        } else {
            this.setPos(this.fontScale);
        }
        this.boxX = fArray[0];
        this.boxY = fArray[1];
        if (this.adjustForWindow) {
            this.setBoxOffsetsInWindow(0.0f, this.isLabelOrHover ? 16.0f * this.fontScale + (float)this.lineHeight : 0.0f, this.boxY - (float)this.textHeight);
        }
        this.y0 = this.boxY + this.yAdj;
    }

    private float getPymolXYOffset(float f, int n, float f2) {
        float f3;
        float f4 = f < -1.0f ? -1.0f : (f3 = f > 1.0f ? 0.0f : (f - 1.0f) / 2.0f);
        f = f < -1.0f || f > 1.0f ? f + (float)(f < 0.0f ? 1 : -1) : 0.0f;
        return f3 * (float)n + f * f2;
    }

    private void setPos(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl;
        boolean bl2 = bl = this.xyz != null;
        if (this.valign == 3 || this.valign == 4) {
            f5 = this.movableXPercent != Integer.MAX_VALUE ? (float)(this.movableXPercent * this.windowWidth / 100) : (bl ? (float)this.movableX : (float)this.movableX * f);
            float f6 = (float)this.offsetX * f;
            f3 = f4 = f5 + f6;
            f2 = f4;
        } else {
            f2 = 5.0f * f;
            f4 = this.windowWidth / 2;
            f3 = (float)this.windowWidth - f2;
        }
        this.boxXY[0] = f2;
        switch (this.align) {
            case 8: {
                this.boxXY[0] = f4 - this.boxWidth / 2.0f;
                break;
            }
            case 12: {
                this.boxXY[0] = f3 - this.boxWidth;
            }
        }
        this.boxXY[1] = 0.0f;
        switch (this.valign) {
            case 0: {
                break;
            }
            case 2: {
                this.boxXY[1] = this.windowHeight / 2;
                break;
            }
            case 1: {
                this.boxXY[1] = this.windowHeight;
                break;
            }
            default: {
                f5 = this.movableYPercent != Integer.MAX_VALUE ? (float)(this.movableYPercent * this.windowHeight / 100) : (bl ? (float)this.movableY : (float)this.movableY * f);
                this.boxXY[1] = (bl ? f5 : (float)this.windowHeight - f5) + (float)this.offsetY * f;
            }
        }
        if (this.align == 8) {
            this.boxXY[1] = this.boxXY[1] - (this.image != null ? this.boxHeight : (this.xyz != null ? this.boxHeight : (float)this.ascent - this.boxHeight)) / 2.0f;
        } else if (this.image != null) {
            this.boxXY[1] = this.boxXY[1] - 0.0f;
        } else if (this.xyz != null) {
            this.boxXY[1] = this.boxXY[1] - (float)(this.ascent / 2);
        }
    }

    public static void setBoxXY(float f, float f2, float f3, float f4, float[] fArray, boolean bl) {
        float f5;
        if (f3 > 0.0f || bl) {
            f5 = f3;
        } else {
            f5 = -f;
            f5 = f3 == 0.0f ? (f5 /= 2.0f) : (f5 += f3);
        }
        float f6 = bl || f4 > 0.0f ? -f2 - f4 : (f4 == 0.0f ? -f2 / 2.0f : -f4);
        fArray[0] = fArray[0] + f5;
        fArray[1] = fArray[1] + f6;
        fArray[2] = f;
        fArray[3] = f2;
    }

    private int stringWidth(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        if (string == null) {
            return 0;
        }
        if (string.indexOf("<su") < 0 && string.indexOf("<color") < 0) {
            return this.font.stringWidth(string);
        }
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            if (string.charAt(i) == '<') {
                String string2;
                int n5;
                if (i + 8 <= n4 && (string.substring(i, i + 7).equals("<color ") || string.substring(i, i + 8).equals("</color>")) && (n5 = string.indexOf(">", i)) >= 0) {
                    i = n5;
                    continue;
                }
                if (i + 5 <= n4 && ((string2 = string.substring(i, i + 5)).equals("<sub>") || string2.equals("<sup>"))) {
                    i += 4;
                    n2 = n3;
                    continue;
                }
                if (i + 6 <= n4 && ((string2 = string.substring(i, i + 6)).equals("</sub>") || string2.equals("</sup>"))) {
                    i += 5;
                    n2 = 1;
                    continue;
                }
            }
            n += this.font.stringWidth(string.substring(i, i + 1)) * n2;
        }
        return n;
    }

    public void setXYA(float[] fArray, int n) {
        if (n == 0) {
            fArray[2] = this.boxX;
            switch (this.align) {
                case 8: {
                    fArray[2] = fArray[2] + this.boxWidth / 2.0f;
                    break;
                }
                case 12: {
                    fArray[2] = fArray[2] + (this.boxWidth - this.xAdj);
                    break;
                }
                default: {
                    fArray[2] = fArray[2] + this.xAdj;
                }
            }
            fArray[0] = fArray[2];
            fArray[1] = this.y0;
        }
        switch (this.align) {
            case 8: {
                fArray[0] = fArray[2] - (float)(this.widths[n] / 2);
                break;
            }
            case 12: {
                fArray[0] = fArray[2] - (float)this.widths[n];
            }
        }
        fArray[1] = fArray[1] + (float)this.lineHeight;
    }

    public void appendFontCmd(SB sB) {
        sB.append("  " + Shape.getFontCommand("echo", this.font));
        if (this.scalePixelsPerMicron > 0.0f) {
            sB.append(" " + 10000.0f / this.scalePixelsPerMicron);
        }
    }
}

