/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.EigenInterface;
import javajs.api.Interface;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;

public final class Measure {
    public static final float radiansPerDegree = (float)Math.PI / 180;
    public static final V3 axisY = V3.new3(0.0f, 1.0f, 0.0f);

    public static float computeAngle(T3 t3, T3 t32, T3 t33, V3 v3, V3 v32, boolean bl) {
        v3.sub2(t3, t32);
        v32.sub2(t33, t32);
        float f = v3.angle(v32);
        return bl ? f / ((float)Math.PI / 180) : f;
    }

    public static float computeAngleABC(T3 t3, T3 t32, T3 t33, boolean bl) {
        V3 v3 = new V3();
        V3 v32 = new V3();
        return Measure.computeAngle(t3, t32, t33, v3, v32, bl);
    }

    public static float computeTorsion(T3 t3, T3 t32, T3 t33, T3 t34, boolean bl) {
        float f;
        float f2 = t3.x - t32.x;
        float f3 = t3.y - t32.y;
        float f4 = t3.z - t32.z;
        float f5 = t33.x - t32.x;
        float f6 = t33.y - t32.y;
        float f7 = t33.z - t32.z;
        float f8 = t33.x - t34.x;
        float f9 = t33.y - t34.y;
        float f10 = t33.z - t34.z;
        float f11 = f3 * f7 - f4 * f6;
        float f12 = f4 * f5 - f2 * f7;
        float f13 = f2 * f6 - f3 * f5;
        float f14 = f6 * f10 - f7 * f9;
        float f15 = f7 * f8 - f5 * f10;
        float f16 = f5 * f9 - f6 * f8;
        float f17 = 1.0f / (f11 * f11 + f12 * f12 + f13 * f13);
        float f18 = 1.0f / (f14 * f14 + f15 * f15 + f16 * f16);
        float f19 = f11 * f14 + f12 * f15 + f13 * f16;
        float f20 = (float)Math.sqrt(f17);
        float f21 = f20 * (f = (float)Math.sqrt(f18));
        float f22 = f19 * f21;
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        if (f22 < -1.0f) {
            f22 = -1.0f;
        }
        float f23 = (float)Math.acos(f22);
        float f24 = f2 * f14 + f3 * f15 + f4 * f16;
        float f25 = Math.abs(f24);
        f23 = f24 / f25 > 0.0f ? f23 : -f23;
        return bl ? f23 / ((float)Math.PI / 180) : f23;
    }

    public static T3[] computeHelicalAxis(P3 p3, P3 p32, Quat quat) {
        V3 v3 = new V3();
        v3.sub2(p32, p3);
        float f = quat.getTheta();
        V3 v32 = quat.getNormal();
        float f2 = v3.dot(v32);
        if (Math.abs(f2) < 1.0E-4f) {
            f2 = 0.0f;
        }
        V3 v33 = new V3();
        v33.cross(v3, v32);
        if (v33.dot(v33) != 0.0f) {
            v33.normalize();
        }
        V3 v34 = new V3();
        V3 v35 = V3.newV(v32);
        if (f2 == 0.0f) {
            f2 = Float.MIN_VALUE;
        }
        v35.scale(f2);
        v34.sub2(v35, v3);
        v34.scale(0.5f);
        v33.scale(f == 0.0f ? 0.0f : (float)((double)v34.length() / Math.tan((double)(f / 2.0f / 180.0f) * Math.PI)));
        V3 v36 = V3.newV(v33);
        if (f != 0.0f) {
            v36.add(v34);
        }
        P3 p33 = P3.newP(p3);
        p33.sub(v36);
        if (f2 != Float.MIN_VALUE) {
            v32.scale(f2);
        }
        P3 p34 = P3.newP(p33);
        p34.add(v32);
        f = Measure.computeTorsion(p3, p33, p34, p32, true);
        if (Float.isNaN(f) || v36.length() < 1.0E-4f) {
            f = quat.getThetaDirectedV(v32);
        }
        float f3 = Math.abs(f == 0.0f ? 0.0f : 360.0f / f);
        float f4 = Math.abs(f2 == Float.MIN_VALUE ? 0.0f : v32.length() * (f == 0.0f ? 1.0f : 360.0f / f));
        return new T3[]{p33, v32, v36, P3.new3(f, f4, f3), p34};
    }

    public static P4 getPlaneThroughPoints(T3 t3, T3 t32, T3 t33, V3 v3, V3 v32, P4 p4) {
        float f = Measure.getNormalThroughPoints(t3, t32, t33, v3, v32);
        p4.set4(v3.x, v3.y, v3.z, f);
        return p4;
    }

    public static void getPlaneThroughPoint(T3 t3, V3 v3, P4 p4) {
        p4.set4(v3.x, v3.y, v3.z, -v3.dot(t3));
    }

    public static float distanceToPlane(P4 p4, T3 t3) {
        return p4 == null ? Float.NaN : (p4.dot(t3) + p4.w) / (float)Math.sqrt(p4.dot(p4));
    }

    public static float directedDistanceToPlane(P3 p3, P4 p4, P3 p32) {
        float f = p4.dot(p3) + p4.w;
        float f2 = p4.dot(p32) + p4.w;
        return Math.signum(f2) * f / (float)Math.sqrt(p4.dot(p4));
    }

    public static float distanceToPlaneD(P4 p4, float f, P3 p3) {
        return p4 == null ? Float.NaN : (p4.dot(p3) + p4.w) / f;
    }

    public static float distanceToPlaneV(V3 v3, float f, P3 p3) {
        return v3 == null ? Float.NaN : (v3.dot(p3) + f) / (float)Math.sqrt(v3.dot(v3));
    }

    public static void calcNormalizedNormal(T3 t3, T3 t32, T3 t33, V3 v3, V3 v32) {
        v32.sub2(t32, t3);
        v3.sub2(t33, t3);
        v3.cross(v32, v3);
        v3.normalize();
    }

    public static float getDirectedNormalThroughPoints(T3 t3, T3 t32, T3 t33, T3 t34, V3 v3, V3 v32) {
        float f = Measure.getNormalThroughPoints(t3, t32, t33, v3, v32);
        if (t34 != null) {
            P3 p3 = P3.newP(t3);
            p3.add(v3);
            float f2 = p3.distance(t34);
            p3.sub2(t3, v3);
            if (f2 > p3.distance(t34)) {
                v3.scale(-1.0f);
                f = -f;
            }
        }
        return f;
    }

    public static float getNormalThroughPoints(T3 t3, T3 t32, T3 t33, V3 v3, V3 v32) {
        Measure.calcNormalizedNormal(t3, t32, t33, v3, v32);
        v32.setT(t3);
        return -v32.dot(v3);
    }

    public static void getPlaneProjection(P3 p3, P4 p4, P3 p32, V3 v3) {
        float f = Measure.distanceToPlane(p4, p3);
        v3.set(p4.x, p4.y, p4.z);
        v3.normalize();
        v3.scale(-f);
        p32.add2(p3, v3);
    }

    public static void getNormalToLine(P3 p3, P3 p32, V3 v3) {
        v3.sub2(p3, p32);
        v3.cross(v3, axisY);
        v3.normalize();
        if (Float.isNaN(v3.x)) {
            v3.set(1.0f, 0.0f, 0.0f);
        }
    }

    public static void getBisectingPlane(P3 p3, V3 v3, T3 t3, V3 v32, P4 p4) {
        t3.scaleAdd2(0.5f, v3, p3);
        v32.setT(v3);
        v32.normalize();
        Measure.getPlaneThroughPoint(t3, v32, p4);
    }

    public static void projectOntoAxis(P3 p3, P3 p32, V3 v3, V3 v32) {
        v32.sub2(p3, p32);
        float f = v32.dot(v3);
        p3.scaleAdd2(f, v3, p32);
        v32.sub2(p3, p32);
    }

    public static void calcBestAxisThroughPoints(P3[] p3Array, P3 p3, V3 v3, V3 v32, int n) {
        int n2 = p3Array.length;
        p3.setT(p3Array[0]);
        v3.sub2(p3Array[n2 - 1], p3);
        v3.normalize();
        Measure.calcAveragePointN(p3Array, n2, p3);
        int n3 = 0;
        while (n3++ < n && (double)Measure.findAxis(p3Array, n2, p3, v3, v32) > 0.001) {
        }
        P3 p32 = P3.newP(p3Array[0]);
        Measure.projectOntoAxis(p32, p3, v3, v32);
        p3.setT(p32);
    }

    public static float findAxis(P3[] p3Array, int n, P3 p3, V3 v3, V3 v32) {
        V3 v33 = new V3();
        V3 v34 = new V3();
        P3 p32 = new P3();
        P3 p33 = new P3();
        V3 v35 = V3.newV(v3);
        float f = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            p32.setT(p3Array[n2]);
            p33.setT(p32);
            Measure.projectOntoAxis(p33, p3, v3, v32);
            v34.sub2(p32, p33);
            v34.cross(v32, v34);
            v33.add(v34);
            f += v32.lengthSquared();
        }
        V3 v36 = V3.newV(v33);
        v36.scale(1.0f / f);
        v34.cross(v36, v3);
        v3.add(v34);
        v3.normalize();
        v34.sub2(v3, v35);
        return v34.length();
    }

    public static void calcAveragePoint(P3 p3, P3 p32, P3 p33) {
        p33.set((p3.x + p32.x) / 2.0f, (p3.y + p32.y) / 2.0f, (p3.z + p32.z) / 2.0f);
    }

    public static void calcAveragePointN(P3[] p3Array, int n, P3 p3) {
        p3.setT(p3Array[0]);
        for (int i = 1; i < n; ++i) {
            p3.add(p3Array[i]);
        }
        p3.scale(1.0f / (float)n);
    }

    public static Lst<P3> transformPoints(Lst<P3> lst, M4 m4, P3 p3) {
        Lst<P3> lst2 = new Lst<P3>();
        for (int i = 0; i < lst.size(); ++i) {
            P3 p32 = P3.newP((T3)lst.get(i));
            p32.sub(p3);
            m4.rotTrans(p32);
            p32.add(p3);
            lst2.addLast(p32);
        }
        return lst2;
    }

    public static boolean isInTetrahedron(P3 p3, P3 p32, P3 p33, P3 p34, P3 p35, P4 p4, V3 v3, V3 v32, boolean bl) {
        boolean bl2 = Measure.distanceToPlane(Measure.getPlaneThroughPoints(p34, p35, p32, v3, v32, p4), p3) >= 0.0f;
        if (bl2 != Measure.distanceToPlane(Measure.getPlaneThroughPoints(p32, p35, p33, v3, v32, p4), p3) >= 0.0f) {
            return false;
        }
        if (bl2 != Measure.distanceToPlane(Measure.getPlaneThroughPoints(p33, p35, p34, v3, v32, p4), p3) >= 0.0f) {
            return false;
        }
        float f = Measure.distanceToPlane(Measure.getPlaneThroughPoints(p32, p33, p34, v3, v32, p4), p3);
        if (bl) {
            return bl2 == f >= 0.0f;
        }
        float f2 = Measure.distanceToPlane(p4, p35);
        return f2 * f <= 0.0f || Math.abs(f2) > Math.abs(f);
    }

    public static Lst<Object> getIntersectionPP(P4 p4, P4 p42) {
        float f;
        float f2;
        float f3;
        float f4 = p4.x;
        float f5 = p4.y;
        float f6 = p4.z;
        float f7 = p4.w;
        float f8 = p42.x;
        float f9 = p42.y;
        float f10 = p42.z;
        float f11 = p42.w;
        V3 v3 = V3.new3(f4, f5, f6);
        V3 v32 = V3.new3(f8, f9, f10);
        V3 v33 = new V3();
        v33.cross(v3, v32);
        float f12 = Math.abs(v33.x);
        float f13 = Math.abs(v33.y);
        float f14 = Math.abs(v33.z);
        int n = f12 > f13 ? (f12 > f14 ? 1 : 3) : (f13 > f14 ? 2 : 3);
        switch (n) {
            case 1: {
                f3 = 0.0f;
                float f15 = f5 * f10 - f9 * f6;
                if ((double)Math.abs(f15) < 0.01) {
                    return null;
                }
                f2 = (f6 * f11 - f10 * f7) / f15;
                f = (f9 * f7 - f11 * f5) / f15;
                break;
            }
            case 2: {
                float f16 = f4 * f10 - f8 * f6;
                if ((double)Math.abs(f16) < 0.01) {
                    return null;
                }
                f3 = (f6 * f11 - f10 * f7) / f16;
                f2 = 0.0f;
                f = (f8 * f7 - f11 * f4) / f16;
                break;
            }
            default: {
                float f17 = f4 * f9 - f8 * f5;
                if ((double)Math.abs(f17) < 0.01) {
                    return null;
                }
                f3 = (f5 * f11 - f9 * f7) / f17;
                f2 = (f8 * f7 - f11 * f4) / f17;
                f = 0.0f;
            }
        }
        Lst<Object> lst = new Lst<Object>();
        lst.addLast(P3.new3(f3, f2, f));
        v33.normalize();
        lst.addLast(v33);
        return lst;
    }

    public static P3 getIntersection(P3 p3, V3 v3, P4 p4, P3 p32, V3 v32, V3 v33) {
        float f;
        Measure.getPlaneProjection(p3, p4, p32, v32);
        v32.set(p4.x, p4.y, p4.z);
        v32.normalize();
        if (v3 == null) {
            v3 = V3.newV(v32);
        }
        if ((double)Math.abs(f = v3.dot(v32)) < 0.01) {
            return null;
        }
        v33.sub2(p32, p3);
        p32.scaleAdd2(v33.dot(v32) / f, v3, p3);
        return p32;
    }

    public static Quat calculateQuaternionRotation(P3[][] p3Array, float[] fArray) {
        Object object;
        fArray[1] = Float.NaN;
        Quat quat = new Quat();
        if (p3Array[0].length == 1 || p3Array[0].length != p3Array[1].length) {
            return quat;
        }
        int n = p3Array[0].length - 1;
        if (n < 2) {
            return quat;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        P3 p3 = new P3();
        P3 p32 = new P3();
        int n2 = n + 1;
        while (--n2 >= 1) {
            object = p3Array[0][n2];
            P3 p33 = p3Array[1][n2];
            p3.sub2((T3)object, p3Array[0][0]);
            p32.sub2(p33, p3Array[0][1]);
            d += (double)p3.x * (double)p32.x;
            d2 += (double)p3.x * (double)p32.y;
            d3 += (double)p3.x * (double)p32.z;
            d4 += (double)p3.y * (double)p32.x;
            d5 += (double)p3.y * (double)p32.y;
            d6 += (double)p3.y * (double)p32.z;
            d7 += (double)p3.z * (double)p32.x;
            d8 += (double)p3.z * (double)p32.y;
            d9 += (double)p3.z * (double)p32.z;
        }
        fArray[0] = Measure.getRmsd(p3Array, quat);
        double[][] dArray = new double[4][4];
        dArray[0][0] = d + d5 + d9;
        double d10 = d6 - d8;
        dArray[1][0] = d10;
        dArray[0][1] = d10;
        double d11 = d7 - d3;
        dArray[2][0] = d11;
        dArray[0][2] = d11;
        double d12 = d2 - d4;
        dArray[3][0] = d12;
        dArray[0][3] = d12;
        dArray[1][1] = d - d5 - d9;
        double d13 = d2 + d4;
        dArray[2][1] = d13;
        dArray[1][2] = d13;
        double d14 = d7 + d3;
        dArray[3][1] = d14;
        dArray[1][3] = d14;
        dArray[2][2] = -d + d5 - d9;
        double d15 = d6 + d8;
        dArray[3][2] = d15;
        dArray[2][3] = d15;
        dArray[3][3] = -d - d5 + d9;
        object = ((EigenInterface)Interface.getInterface("javajs.util.Eigen")).setM(dArray).getEigenvectorsFloatTransposed()[3];
        quat = Quat.newP4(P4.new4((float)object[1], (float)object[2], (float)object[3], (float)object[0]));
        fArray[1] = Measure.getRmsd(p3Array, quat);
        return quat;
    }

    public static float getTransformMatrix4(Lst<P3> lst, Lst<P3> lst2, M4 m4, P3 p3) {
        P3[] p3Array = Measure.getCenterAndPoints(lst);
        P3[] p3Array2 = Measure.getCenterAndPoints(lst2);
        float[] fArray = new float[2];
        Quat quat = Measure.calculateQuaternionRotation(new P3[][]{p3Array, p3Array2}, fArray);
        M3 m3 = quat.getMatrix();
        if (p3 == null) {
            m3.rotate(p3Array[0]);
        } else {
            p3.setT(p3Array[0]);
        }
        V3 v3 = V3.newVsub(p3Array2[0], p3Array[0]);
        m4.setMV(m3, v3);
        return fArray[1];
    }

    public static P3[] getCenterAndPoints(Lst<P3> lst) {
        int n = lst.size();
        P3[] p3Array = new P3[n + 1];
        p3Array[0] = new P3();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                P3 p3 = (P3)lst.get(i);
                p3Array[i + 1] = p3;
                p3Array[0].add(p3);
            }
            p3Array[0].scale(1.0f / (float)n);
        }
        return p3Array;
    }

    public static float getRmsd(P3[][] p3Array, Quat quat) {
        double d = 0.0;
        P3[] p3Array2 = p3Array[0];
        P3[] p3Array3 = p3Array[1];
        P3 p3 = p3Array2[0];
        P3 p32 = p3Array3[0];
        int n = p3Array2.length - 1;
        P3 p33 = new P3();
        int n2 = n + 1;
        while (--n2 >= 1) {
            p33.sub2(p3Array2[n2], p3);
            quat.transform2(p33, p33).add(p32);
            d += (double)p33.distanceSquared(p3Array3[n2]);
        }
        return (float)Math.sqrt(d / (double)n);
    }
}

